<?php
// File monitoring.php

// File log yang akan dibaca
$file_log = "request_log.txt";

// Membaca konten log
$log_content = "";
if (file_exists($file_log)) {
    $log_content = file_get_contents($file_log);
    $log_lines = explode("\n", $log_content);
} else {
    $log_lines = [];
}

// Data lokasi perangkat (disesuaikan dengan IP)
$device_locations = [
     "114.10.46.163" => "kost",
    "114.5.104.81" => "Gedung Lab Teknik Elektro",
    "120.188.75.253"=> "Lab Robotika"
];

// Ambil data yang direquest dari server target
$url_target = "https://iot2.ruangbelajar.xyz/2024-EWS/readVMS.php";
$data_request = file_get_contents($url_target);

// Hitung total data yang berhasil dikirim (dalam byte)
$total_data_size = 0;

foreach ($log_lines as $line) {
    if (strpos($line, "Status: Berhasil") !== false) {
        preg_match("/Data Size: (\\d+) bytes/", $line, $matches);
        if (!empty($matches[1])) {
            $total_data_size += (int)$matches[1];
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Monitoring Waktu Request ESP</title>
    <!-- CDN CSS DataTables -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        h1 {
            text-align: center;
            color: #333;
        }
        table {
            width: 100%;
            margin-top: 20px;
        }
        th {
            background-color: #6495ED; 
            color: white;
            text-align: center;
        }
        td {
            text-align: center;
        }
        .server-data {
            background-color: #f9f9f9;
            border: 1px solid #ddd;
            padding: 10px;
            margin: 20px 0;
            font-size: 18px;
            text-align: center;
            font-weight: bold;
        }
        /* Highlight berdasarkan status */
        .status-aman {
            color: white;
            background-color: #28a745; /* Hijau */
        }
        .status-siaga {
            color: black;
            background-color: #ffc107; /* Kuning */
        }
        .status-bahaya {
            color: white;
            background-color: #dc3545; /* Merah */
        }
    </style>
</head>
<body>
    <h1>Monitoring Waktu Request ESP8266 ke Server</h1>
    
    <!-- Bagian Data dari Server Target -->
    <div class="server-data" id="statusContainer">
        <strong>Data Level ketinggian Air:</strong><br>
        <span id="statusData"><?php echo htmlspecialchars($data_request); ?></span>
    </div>

  
    <!-- Bagian Tabel Dinamis -->
    <table id="logTable" class="display">
        <thead>
            <tr>
                <th>No</th>
                <th>Waktu</th>
                <th>IP</th>
                <th>Lokasi Perangkat</th>
                <th>Status Data Terkirim</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $no = 1;
            foreach ($log_lines as $line) {
                if (!empty($line)) {
                    // Pisahkan data log menggunakan pemisah "|"
                    $parts = explode("|", $line);
                    $waktu = trim(str_replace("Waktu:", "", $parts[0]));
                    $ip = trim(str_replace("IP:", "", $parts[1]));
                    $status = isset($parts[2]) ? trim(str_replace("Status:", "", $parts[2])) : "";
                    $data_size = isset($parts[3]) ? trim(str_replace("Data Size:", "", $parts[3])) : "0";
                    $lokasi = isset($device_locations[$ip]) ? $device_locations[$ip] : "Tidak Diketahui";

                    echo "<tr>";
                    echo "<td>$no</td>";
                    echo "<td>$waktu</td>";
                    echo "<td>$ip</td>";
                    echo "<td>$lokasi</td>";
                    echo "<td>$status</td>";
                    echo "</tr>";
                    $no++;
                }
            }
            ?>
        </tbody>
    </table>

    <!-- CDN jQuery dan DataTables -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

    <script>
        $(document).ready(function() {
            // Aktifkan DataTables
            $('#logTable').DataTable({
                "pageLength": 50,
                "order": [[1, "desc"]]
            });

            // Highlight status pada data dari server
            function highlightStatus() {
                const statusData = document.getElementById("statusData").innerText.toLowerCase();
                const statusContainer = document.getElementById("statusContainer");

                if (statusData.includes("aman")) {
                    statusContainer.className = "server-data status-aman";
                } else if (statusData.includes("siaga")) {
                    statusContainer.className = "server-data status-siaga";
                } else if (statusData.includes("bahaya")) {
                    statusContainer.className = "server-data status-bahaya";
                }
            }

            highlightStatus(); // Panggil saat halaman dimuat

            // Auto-refresh hanya jika ada request baru
            let lastLog = "<?php echo md5($log_content); ?>"; // Hash log awal
            setInterval(function() {
                $.ajax({
                    url: 'check_log.php',
                    method: 'GET',
                    success: function(response) {
                        if (response !== lastLog) {
                            location.reload(); // Refresh halaman
                        }
                    }
                });
            }, 5000); // Cek setiap 5 detik
        });
    </script>
</body>
</html>
