<?php
// Error reporting settings
error_reporting(E_ALL & ~E_WARNING);
ini_set('display_errors', 0);
ini_set('log_errors', 0);

require 'vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

// Set timezone
date_default_timezone_set('Asia/Jakarta');

$config = "config.json";
if (!file_exists($config)) {
    echo "File config not found !";
}
$config = file_get_contents($config);
$config = json_decode($config, true);

if ($config['status'] !== 'enable') {
    // kill service
    $output = [];
    exec('ps aux | grep inotifywait', $output);
    foreach ($output as $line) {
        if (strpos($line, 'grep') === false) {
            $parts = preg_split('/\s+/', $line);
            $pid = $parts[1];
            exec("kill -9 " . $pid);
        }
    }
    die("Status tidak dalam kondisi 'enable', status saat ini: " . $config['status']);
}
if ($config['monitoring']['notification']['status'] !== 'true') {
    $sendNotification = false;
}else{
    $sendNotification = true;
}
if($config['monitoring']['notification']['tls'] !== 'true'){
    $useTLS = false;
}else{
    $useTLS = true;
}
// Configurations
$userHome = '/home/' . exec('whoami') . '/';
$includePaths = str_replace("\n", " ", $config['monitoring']['paths']['include']);
$includePaths = $userHome . str_replace(" ", " " . $userHome, $includePaths);
$excludePaths = str_replace("\n", "|", $config['monitoring']['paths']['exclude']);
$excludePaths = $userHome . str_replace("|", "|" . $userHome, $excludePaths);
$hashFileChanged = $config['monitoring']['log']['changed'];
$emailTo = $config['monitoring']['notification']['email'];
$emailFrom = $config['monitoring']['notification']['smtp_username'];
$smtpHost = $config['monitoring']['notification']['smtp_server'] ?? 'localhost';
$smtpPort = (int) $config['monitoring']['notification']['smtp_port'];
$smtpUser = $config['monitoring']['notification']['smtp_username'];
$smtpPass = $config['monitoring']['notification']['smtp_password'];
$useTLS = $useTLS;

// Function to send email notifications
function sendEmail($to, $subject, $message, $from, $smtpHost, $smtpPort, $smtpUser, $smtpPass, $useTLS) {
    $mail = new PHPMailer(true);

    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host = $smtpHost;
        $mail->SMTPAuth = true;
        $mail->Username = $smtpUser;
        $mail->Password = $smtpPass;
        $mail->Port = $smtpPort;

        if ($useTLS) {
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        }

        // Recipients
        $mail->setFrom($from, 'Integrity Monitoring');
        $mail->addAddress($to);

        // Content
        $mail->isHTML(false);
        $mail->Subject = $subject;
        $mail->Body = $message;

        $mail->send();
    } catch (Exception $e) {
        error_log("Message could not be sent. Mailer Error: {$mail->ErrorInfo}");
    }
}
if($excludePaths == ""){
    $command = "inotifywait -m -e modify,create,delete,moved_to,moved_from --recursive --exclude '/home/".exec('whoami')."/.cpanel/integrity/changed.log' --format '%w%f %e' ".$includePaths." | while read file event; do echo \"$(date '+%d-%m-%Y %H:%M:%S') - \$file - \$event\" >> /home/".exec('whoami')."/.cpanel/integrity/changed.log; done";
}else{
    $command = "inotifywait -m -e modify,create,delete,moved_to,moved_from --recursive --exclude '/home/".exec('whoami')."/.cpanel/integrity/changed.log|".$excludePaths."' --format '%w%f %e' ".$includePaths." | while read file event; do echo \"$(date '+%d-%m-%Y %H:%M:%S') - \$file - \$event\" >> /home/".exec('whoami')."/.cpanel/integrity/changed.log; done";
}
// Check if the current time is 00:00
$current_time = date('H:i');
if ($current_time === '00:00') {
    // Restart Service
    $output = [];
    exec('ps aux | grep inotifywait', $output);
    foreach ($output as $line) {
        if (strpos($line, 'grep') === false) {
            $parts = preg_split('/\s+/', $line);
            $pid = $parts[1];
            exec("kill -9 " . $pid);
        }
    }
    $p = popen($command . " &", "r");
    pclose($p);
    
    // Check for changes last 24hours
    if (file_exists($hashFileChanged)) {
        $log_lines = file($hashFileChanged);
        $changes = false;
        $now = time();
        $lstscan = substr(end($log_lines), 0, 19);
        $log_time = DateTime::createFromFormat('d-m-Y H:i:s', $lstscan);
        if ($log_time && ($now - $log_time->getTimestamp()) <= 86400) { // 86400 seconds in 24 hours
            $changes = true;
        }
    }
    // Trim log file if it exceeds 10000 lines
    $maxLines = 10000;
    $logLines = file($hashFileChanged, FILE_IGNORE_NEW_LINES);
    $totalLines = count($logLines);
    
    if ($totalLines > $maxLines) {
        $logLines = array_slice($logLines, -$maxLines);
        file_put_contents($hashFileChanged, implode(PHP_EOL, $logLines) . PHP_EOL);
    }
    // Send notification if changes detected
    if ($changes) {
    
        if ($sendNotification) {
            $message = "We have detected changes in file integrity on your cpanel account in last 24hours. Please review the logs in the dashboard to verify if these modifications are authorized.";
            $subject = "[ALERT] File Integrity Changes Detected";
            sendEmail($emailTo, $subject, $message, $emailFrom, $smtpHost, $smtpPort, $smtpUser, $smtpPass, $useTLS);
        }
    }
}else{
    $output = [];
    exec('ps aux | grep inotifywait', $output);
    $pids = [];
    foreach ($output as $line) {
        if (strpos($line, 'grep') === false) {
            $parts = preg_split('/\s+/', $line);
            $pids[] = $parts[1];
        }
    }
    if (count($pids) < 2) {
        $p = popen($command . " &", "r");
        pclose($p);
    }
    // Check if the config file was updated within the last minute
    $configUpdatedAt = DateTime::createFromFormat('d-m-Y H:i:s', $config['updated_at']);
    if ($configUpdatedAt && (time() - $configUpdatedAt->getTimestamp()) < 60) {
        // Restart Service
        $output = [];
        exec('ps aux | grep inotifywait', $output);
        foreach ($output as $line) {
            if (strpos($line, 'grep') === false) {
                $parts = preg_split('/\s+/', $line);
                $pid = $parts[1];
                exec("kill -9 " . $pid);
            }
        }
        $p = popen($command . " &", "r");
        pclose($p);
    }
}
// Check if error_log file exists in the current directory and delete it
$errorLogFile = __DIR__ . '/error_log';
if (file_exists($errorLogFile)) {
    unlink($errorLogFile);
}
?>
